﻿Imports System.Data

Partial Class SystemAdmin_PaymentDetail
    Inherits System.Web.UI.Page

    Protected Sub btSearch_Click(sender As Object, e As EventArgs) Handles btSearch.Click
        Dim strPNRCode As String = RTrim(LTrim(txtPNRCode.Text)) ' Trim(Replace(txtPNRCode.Text, " ", ""))
        If Len(strPNRCode) > 5 Then
            If strPNRCode <> "" Then LoadHistoryLog(strPNRCode)
            If strPNRCode <> "" Then LoadHistoryLog_Log(strPNRCode) 'GDActivityLog

        End If

    End Sub
    Sub LoadHistoryLog(ByVal strPNRCode As String) ' format yyyy-MM-dd

        Try
            Dim DtProductDetail As New DataTable
            DtProductDetail = getProductDetail(strPNRCode)


            If DtProductDetail.DefaultView.Count > 0 Then
                'DtBookingDetail.DefaultView.Sort = ViewState("SortExpression") & " " & ViewState("SortDirection")
                GvHistoryLog.DataSource = DtProductDetail
                GvHistoryLog.DataBind()
                lblResult.Text = " " & DtProductDetail.DefaultView.Count & " items."
            Else
                GvHistoryLog.DataSource = Nothing
                GvHistoryLog.DataBind()
                lblResult.Text = " 0 items."
            End If
        Catch ex As Exception
            writeErrorLog("LoadHistoryLog", ex.Message.ToString())
        End Try
    End Sub

    Sub LoadHistoryLog_Log(ByVal strPNRCode As String) ' format yyyy-MM-dd

        Try
            Dim DtProductDetail As New DataTable
            DtProductDetail = getBookingDetail_ActivityLog(strPNRCode)


            If DtProductDetail.DefaultView.Count > 0 Then
                'DtBookingDetail.DefaultView.Sort = ViewState("SortExpression") & " " & ViewState("SortDirection")
                GDActivityLog.DataSource = DtProductDetail
                GDActivityLog.DataBind()
                lblResult_ActivityLog.Text = " " & DtProductDetail.DefaultView.Count & " items."
            Else
                GDActivityLog.DataSource = Nothing
                GDActivityLog.DataBind()
                lblResult_ActivityLog.Text = " 0 items."
            End If
        Catch ex As Exception
            writeErrorLog("LoadHistoryLog_Log", ex.Message.ToString())
        End Try
    End Sub

    Sub writeErrorLog(ByVal strFunctionName As String, ByVal strError As String)
        lblError.Visible = True
        lblError.Text = "[" & strFunctionName & "] Err=" & strError
    End Sub

#Region "get Booking Detail"
    Function getProductDetail(ByVal strPNRCode As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_BookingDetail_Payment_Current(strPNRCode)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function


    Function getBookingDetail_ActivityLog(ByVal strPNRCode As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_BookingDetail_Payment_Log(strPNRCode)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function
  


#End Region

    Protected Sub GvHistoryLog_RowDataBound(sender As Object, e As GridViewRowEventArgs) Handles GvHistoryLog.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            e.Row.Cells(0).Text = e.Row.DataItemIndex + 1
        End If
    End Sub
    Protected Sub GDActivityLog_RowDataBound(sender As Object, e As GridViewRowEventArgs) Handles GDActivityLog.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            e.Row.Cells(0).Text = e.Row.DataItemIndex + 1
        End If
    End Sub
End Class
