﻿
Imports System.Data

Partial Class SystemAdmin_HistoryLog
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load

        If Not Page.IsPostBack Then
            ViewState("SortExpression") = "HistoryDateTime"
            ViewState("SortDirection") = "ASC"

            txtDate.Text = getCurrentDate()
            LoadHistoryLog(txtDate.Text)
        End If
    End Sub
    Function getCurrentDate() As String
        Dim strDate As String = ""
        strDate = Date.Now.ToString("yyyy-MM-dd")
        Return strDate
    End Function

    Protected Sub btSearch_Click(sender As Object, e As EventArgs) Handles btSearch.Click
        Dim strDateSearch As String = txtDate.Text
        LoadHistoryLog(strDateSearch)
    End Sub

    Sub LoadHistoryLog(ByVal strDate As String) ' format yyyy-MM-dd


        Try
            Dim DtCustomerLog As New DataTable
            DtCustomerLog = getCustomerLog(strDate)
            lblHeaderDate.Text = ConvertDateString(strDate)


            If DtCustomerLog.DefaultView.Count > 0 Then
                DtCustomerLog.DefaultView.Sort = ViewState("SortExpression") & " " & ViewState("SortDirection")
                GvHistoryLog.DataSource = DtCustomerLog
                GvHistoryLog.DataBind()
                lblResult.Text = " " & DtCustomerLog.DefaultView.Count & " items."
            Else
                GvHistoryLog.DataSource = Nothing
                GvHistoryLog.DataBind()
                lblResult.Text = " 0 items."
            End If
        Catch ex As Exception
            writeErrorLog("LoadHistoryLog", ex.Message.ToString())
        End Try
    End Sub
    Sub writeErrorLog(ByVal strFunctionName As String, ByVal strError As String)
        lblError.Visible = True
        lblError.Text = "[" & strFunctionName & "] Err=" & strError
    End Sub

    Function ConvertDateString(ByVal strDate As String) As String
        'strDate => yyyy-mm-dd 
        'output => dd/mm/yyyy
        Dim strDateReturn As String = ""
        Dim ArrDate() As String
        Try
            ArrDate = Split(strDate, "-")
            strDateReturn = ArrDate(2) & "/" & ArrDate(1) & "/" & ArrDate(0)
        Catch ex As Exception
            strDateReturn = strDate
        End Try
        Return strDateReturn
    End Function

    Protected Sub GvHistoryLog_Sorting(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewSortEventArgs) Handles GvHistoryLog.Sorting
        Try
            If ViewState("SortExpression") = e.SortExpression Then ' กรณีที่เป็นฟิลด์เดิม
                If ViewState("SortDirection") = "ASC" Then
                    ViewState("SortDirection") = "DESC"
                Else
                    ViewState("SortDirection") = "ASC"
                End If
            Else
                ViewState("SortExpression") = e.SortExpression
                ViewState("SortDirection") = "ASC"
            End If

            Dim strDateSearch As String = txtDate.Text
            LoadHistoryLog(strDateSearch)
        Catch ex As Exception
            writeErrorLog("GvHistoryLog_Sorting", ex.Message.ToString())
        End Try
    End Sub

#Region "get Database MushroomTravel"
    Function getSaleMushroom() As DataTable
        Dim Dt As New DataTable
        Dim ClsMUser As New MushroomTravel.M_User
        ClsMUser.ConnectionString = System.Configuration.ConfigurationSettings.AppSettings("MushroomTravel")

        Try
            With ClsMUser
                .Where.WhereClauseReset()
                .LoadAll()
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMUser = Nothing
        End Try
        Return Dt
    End Function

#End Region
#Region "get Database CallCenter"
    Function getCustomerLog(ByVal strDate As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsCallLog As New CallCenterLog
        Try
            With ClsCallLog
                .Where.WhereClauseReset()
                ._Proc_LoadHistoryLogByDate(strDate)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsCallLog = Nothing
        End Try
        Return Dt
    End Function
#End Region

    Protected Sub GvHistoryLog_RowDataBound(sender As Object, e As GridViewRowEventArgs) Handles GvHistoryLog.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            e.Row.Cells(0).Text = e.Row.DataItemIndex + 1
        End If
    End Sub
End Class
