USE [TourProX_ALL]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Alter PROCEDURE [dbo].[_HistoryLog_Agent_BookingDelete] 
(
	@AgentID int =   3574 ,
	@DeleteDate varchar(20) ='2019-05-15'
)

AS

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

select M.FNameTH as NameDel , M.Email as EmailDel , convert(varchar,WD.DeleteDateTime,113)  as DeleteDate   , convert(varchar,WD.DateRegis,113)  as BookingDate ,  WD.RowIDEmail , WD.StatusCode , P.ProductCodeNew , P.ProductNameTH , convert(varchar,TPD.ColStartDate,106) as PeriodStart 
, convert(varchar,TPD.ColEndDate ,106) as PeriodEnd 
from WebBookingDeleteLog WD
inner join Member M on WD.DeleteByUserID = M.MemberID 
inner join Product P on P.ProductID = WD.ProductID 
inner join T_ProductDetail TPD on TPD.Product_detailID = WD.Product_detailID 
where WD.AgentID_Owner =@AgentID 
and  
( ( WD.DeleteDateTime between @DeleteDate+' 00:00:00' and @DeleteDate+' 23:59:59' and @DeleteDate <>'' )
	or
  (  @DeleteDate ='' )
)
order by WD.DateRegis desc

