﻿
Imports System.Data
Partial Class SystemAdmin_ClearDetail
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        If Not Page.IsPostBack Then
            If txtDateDel.Text = "" Then txtDateDel.Text = Now.Year.ToString() + "-" + Now.Month.ToString("00") + "-" + Now.Day.ToString("00")
            lblBookingDel.Text = "Booking ที่ถูกลบ " & txtDateDel.Text
        End If
    End Sub

    Sub LoadAgentData()
        '--- Get Data ----
        Dim strAgentIDGetURL As String = ""
        Dim strAgentID As String = RTrim(LTrim(txtAgentID.Text))
        Dim strURLWebsite As String = RTrim(LTrim(txtURLWebsite.Text))
        Dim strBookingDate As String = RTrim(LTrim(txtDateDel.Text))
        If strAgentID <> "" Or strURLWebsite <> "" Then
            strAgentIDGetURL = LoadHistoryLog(strAgentID, strURLWebsite)
            If strAgentIDGetURL <> "" Then
                strAgentID = strAgentIDGetURL
                LoadTourByType(strAgentID)
                LoadBookingDel(strAgentID, strBookingDate)
            End If
        End If
    End Sub
    Sub LoadTourByType(ByVal strAgentID As String) ' format yyyy-MM-dd

        Try
            Dim DtProductDetail As New DataTable
            DtProductDetail = getTourByType(strAgentID)

            If DtProductDetail.DefaultView.Count > 0 Then
                'DtBookingDetail.DefaultView.Sort = ViewState("SortExpression") & " " & ViewState("SortDirection")
                GVLoadTourbyType.DataSource = DtProductDetail
                GVLoadTourbyType.DataBind()
                txtLoadTourByType.Text = " " & DtProductDetail.DefaultView.Count & " items."
            Else
                GVLoadTourbyType.DataSource = Nothing
                GVLoadTourbyType.DataBind()
                txtLoadTourByType.Text = " 0 items."
            End If
        Catch ex As Exception
            writeErrorLog("LoadTourByType", ex.Message.ToString())
        End Try
    End Sub


    Sub LoadBookingDel(ByVal strAgentID As String, ByVal strBookingDel As String) ' format yyyy-MM-dd

        Try
            Dim DtProductDetail As New DataTable
            DtProductDetail = getBookingDel(strAgentID, strBookingDel)

            If DtProductDetail.DefaultView.Count > 0 Then
                'DtBookingDetail.DefaultView.Sort = ViewState("SortExpression") & " " & ViewState("SortDirection")
                GVBookingDel.DataSource = DtProductDetail
                GVBookingDel.DataBind()
                lblResultBookingDel.Text = " " & DtProductDetail.DefaultView.Count & " items."
            Else
                GVBookingDel.DataSource = Nothing
                GVBookingDel.DataBind()
                lblResultBookingDel.Text = " 0 items."
            End If
        Catch ex As Exception
            writeErrorLog("LoadTourByType", ex.Message.ToString())
        End Try
    End Sub

    Function LoadHistoryLog(ByVal strAgentID As String, ByVal strURLWebsite As String) As String  ' format yyyy-MM-dd
        Dim strAgentID_Return As String = ""
        Try
            If strAgentID <> "" Then strAgentID_Return = strAgentID
            If strAgentID = "" Then strAgentID = 0
            Dim DtProductDetail As New DataTable
            DtProductDetail = getAgentDetail(strAgentID, strURLWebsite)

            If DtProductDetail.DefaultView.Count > 0 Then
                'DtBookingDetail.DefaultView.Sort = ViewState("SortExpression") & " " & ViewState("SortDirection")
                strAgentID_Return = DtProductDetail.DefaultView(0)("AgentID").ToString()
                GvHistoryLog.DataSource = DtProductDetail
                GvHistoryLog.DataBind()
                lblResult.Text = " " & DtProductDetail.DefaultView.Count & " items."
            Else
                GvHistoryLog.DataSource = Nothing
                GvHistoryLog.DataBind()
                lblResult.Text = " 0 items."
            End If
        Catch ex As Exception
            writeErrorLog("LoadHistoryLog", ex.Message.ToString())
        End Try
        Return strAgentID_Return
    End Function

    Function getAgentDetail(ByVal strAgentID As String, ByVal strURLWebsite As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_AgentDetail_FindURL(strAgentID, strURLWebsite)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function


    Function getTourByType(ByVal strAgentID As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_Agent_WebHomeProduct(strAgentID)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function

    Function getBookingDel(ByVal strAgentID As String, ByVal strBookingDel As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_Agent_BookingDelete(strAgentID, strBookingDel)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function

    Sub writeErrorLog(ByVal strFunctionName As String, ByVal strError As String)
        lblError.Visible = True
        lblError.Text = "[" & strFunctionName & "] Err=" & strError
    End Sub
    Protected Sub btSearch_Click(sender As Object, e As EventArgs) Handles btSearch.Click
        Dim strText As String = txtDateDel.Text
        If txtDateDel.Text = "" Then strText = "ทั้งหมด"
        lblBookingDel.Text = "Booking ที่ถูกลบ " & strText
        LoadAgentData()
    End Sub
End Class
