﻿Imports MyGeneration.dOOdads
Imports System.Data
Imports System.Configuration
'----------------------------------------------------------
Imports System
Imports System.Collections.Generic
Imports System.Text
Imports System.Net
Imports Newtonsoft.Json
Imports System.Web.Script.Serialization
Imports System.IO


Partial Class SystemAdmin_TestFunction
    Inherits System.Web.UI.Page

    Function getDataFromPlexTel(ByVal strURLGet As String) As DataTable
        Dim DTable As New DataTable
        Try
            Dim objSURL As New StringBuilder
            Dim objURL As Uri
            Dim strURL As String

            strURL = strURLGet
            objSURL.Append(strURL)
            objURL = New Uri(objSURL.ToString())

            Dim request As HttpWebRequest = HttpWebRequest.Create(objURL)
            Dim response As HttpWebResponse = request.GetResponse
            Dim reader As New StreamReader(response.GetResponseStream())

            If Not IsNothing(reader) Then
                Dim strResponse = reader.ReadToEnd
                DTable = JsonConvert.DeserializeObject(Of DataTable)(strResponse)
            End If
            reader.Close()
            response.Close()
        Catch ex As Exception
            DTable = New DataTable
            WriteErrorLog("getDataFromPlexTel", ex.Message.ToString(), strURLGet)
        End Try
        Return DTable
    End Function

    Protected Sub BtGetData_Click(sender As Object, e As EventArgs) Handles BtGetData.Click
        Dim Dtable As New DataTable
        Dim strURL As String = txtURL.Text

        Try
            Dtable = getDataFromPlexTel(Trim(strURL))

            GvData.DataSource = Nothing
            GvData.DataBind()
            If Dtable.Rows.Count > 0 Then
                GvData.DataSource = Dtable
                GvData.DataBind()
            End If

            lblInformation.Text = "Result Data : " & Dtable.Rows.Count & " item."

        Catch ex As Exception
            WriteErrorLog("BtGetData_Click", ex.Message.ToString(), strURL)
        End Try


    End Sub

    Sub WriteErrorLog(ByVal strFunctionName As String, ByVal strErrorName As String, ByVal strDetail As String)
        lblError.Visible = True
        lblError.Text = "<br>[<b>" & strFunctionName & "</b>] <b>Err</b>=" & strErrorName & "<br><b>Detail</b>:" & strDetail
    End Sub

    Protected Sub BtClear_Click(sender As Object, e As EventArgs) Handles BtClear.Click
        lblInformation.Text = ""
        txtURL.Text = ""
        GvData.DataSource = Nothing
        GvData.DataBind()
        lblError.Visible = False
    End Sub
End Class
