﻿Imports MyGeneration.dOOdads
Imports System.Data
Imports System.Configuration
'----------------------------------------------------------
Imports System
Imports System.Collections.Generic
Imports System.Text
Imports System.Net
Imports Newtonsoft.Json
Imports System.Web.Script.Serialization
Imports System.IO

Partial Class AnalyzeCall
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        Dim strReturn As String = ""
        Dim intLogID As Integer = 0
        Dim blnInTimeOffice As Boolean = False
        Dim strCallerID As String = ""
        Dim strUniqueID As String = ""
        Dim strStepnumber As String = ""
        Dim strCustomerCall As String = "" ' เบอร์ของ Mushroom ที่เรียกมา"


        'CallerID=0850968413&UniqueID=150&Stepnumber=1 ข้อมูลที่ใช้ในการทดสอบ
        If Not (Page.IsPostBack) Then
            '--- เป็นข้อมูลที่ทาง Plextel ส่งมาให้ ---
            If Not IsNothing(Request.QueryString("CallerID")) Then strCallerID = Request.QueryString("CallerID")
            If Not IsNothing(Request.QueryString("UniqueID")) Then strUniqueID = Request.QueryString("UniqueID")
            If Not IsNothing(Request.QueryString("Stepnumber")) Then strStepnumber = Request.QueryString("Stepnumber")
            If Not IsNothing(Request.QueryString("CustomerCall")) Then strCustomerCall = Request.QueryString("CustomerCall") ' เบอร์ของ Mushroom ที่เรียกมา


            '--- ตรวจสอบเวลา นอกเวลาทำการ จะต้อง Return ค่าเป็น Default ถึงแม้ว่าจะเป็นลูกค้าใหม่ หรือ ลูกค้าเก่าก็ตาม
            If CheckTimeInOffice() Then
                blnInTimeOffice = True
                '--- เป็นการ Return ค่า ----
                If Not IsNothing(strCallerID) Then
                    intLogID = SaveLog(strCallerID, strUniqueID, strStepnumber, strCustomerCall)
                    strReturn = AnalyzeCall(strCallerID, strUniqueID, strStepnumber, strCustomerCall)
                End If

            End If
            If strReturn = "" Then strReturn = "OK,,,Default,D," & strCustomerCall
            'If strCallerID = "1010" Then strReturn = Replace(strReturn, "Default", "newyear") ' กรณีจะเปลี่ยนเสียงได้จะต้องเป็นเฉพาะ วิเคราะห์ด้วย Sale เท่านั้น
            updateReturnValue(intLogID, strReturn, blnInTimeOffice)
            ReturnToPlexTel(strReturn)
        End If
    End Sub
    Function CheckTimeInOffice() As Boolean
        Dim bln As Boolean = True
        Try
            Dim blnInTime As Boolean = True
            Dim DTimeStart, DTimeEnd As DateTime
            Dim CurrentDTime As New DateTime()
            Dim intDayInWeek As Integer = 0
            CurrentDTime = DateTime.Now.ToString("yyyy-MM-dd hh:mm:ss")
            DTimeStart = DateTime.Now.ToString("yyyy-MM-dd") & " 09:00:00"
            DTimeEnd = DateTime.Now.ToString("yyyy-MM-dd") & " 23:00:00"

            If DateDiff(DateInterval.Minute, DTimeStart, CurrentDTime) < 1 Then
                ' ถ้าน้อยกว่า แสดงว่า โทรมาก่อนเวลาทำงาน
                blnInTime = False
            End If
            If blnInTime Then
                If DateDiff(DateInterval.Minute, DTimeEnd, CurrentDTime) > 1 Then
                    ' ถ้ามากกว่า แสดงว่า โทรมาหลังเวลาทำงาน
                    blnInTime = False
                End If
            End If
            '------------------------------------------------------------------------
            If blnInTime Then
                If DateTime.Now.DayOfWeek <> DayOfWeek.Sunday Then
                    bln = True
                End If
            End If
        Catch ex As Exception
            bln = False
        End Try
        Return bln
    End Function
    Sub updateReturnValue(ByVal intLogID As Integer, ByVal strReturn As String, ByVal blnInTimeOffice As Boolean)

        Dim ClsC As New CallCenterLog
        Try
            With ClsC
                .Where.WhereClauseReset()
                .Where.LogID.Value = intLogID
                .Query.Load()
                If .DefaultView.Count > 0 Then
                    .ReturnValue = strReturn
                    .IsInTimeOffice = blnInTimeOffice
                    .Save()
                End If
            End With
        Catch ex As Exception
        Finally
            ClsC = Nothing
        End Try

    End Sub
    Function SaveLog(ByVal strCallerID As String, ByVal strUniqueID As String, ByVal strStepnumber As String, ByVal strCustomerCall As String) As Integer
        Dim intLogID As Integer
        Dim ClsC As New CallCenterLog
        Try
            With ClsC
                .AddNew()
                .CallerID = strCallerID
                .UniqueID = strUniqueID
                .Stepnumber = strStepnumber
                .CallDateTime = DateTime.Now
                .CustomerCall = strCustomerCall
                .Save()
                intLogID = CInt(.LogID)
            End With
        Catch ex As Exception
        Finally
            ClsC = Nothing
        End Try
        Return intLogID
    End Function
    Function AnalyzeCall(ByVal strCallerID As String, ByVal strUniqueID As String, ByVal strStepnumber As String, ByVal strCustomerCall As String) As String
        Dim strReturn As String = ""
        Dim intPassengerID As Integer = 0
        Dim intCustomerCompamyID As Integer = 0
        Dim intSaleID As Integer
        Dim strBookingRefNo As String = ""
        Dim strTypeProduct As String = ""
        Dim strPhoneNumber As String = ""
        Dim intWaitingTimeSecond As Integer = GetSetWaitingTime()
        Dim blnProcessQueue As Boolean = False
        Dim intStep As Integer = 0
        Dim strQueueName As String = ""
        Dim strMusicName As String = ""

        Try
            intStep = CInt(strStepnumber)
        Catch ex As Exception
            intStep = 10 ' เพื่อโยนให้ Queue ไปเลย
        End Try
        Try


            strReturn = "OK,,,Default,D," & strCustomerCall  '- -ของเดิม "OK,,,Default,D"

            If CheckExistCallerIDInDatabase(strCallerID, intPassengerID, intCustomerCompamyID) Then ' กรณีที่ตรวจสอบแล้วไม่มีใน Database
                '-- ได้ข้อมูล ทั้ง Passenger & Cusomter ออกมาแล้ว โดยหาเฉพาะที่ ContactID กับ CustomerCompanyID เท่านั้น
                If intPassengerID <> 0 Or intCustomerCompamyID <> 0 Then
                    ' กรณีที่มีเบอร์โทร แต่หา ID ไม่ได้
                    GetLastBookingByContactAndCompany(intPassengerID, intCustomerCompamyID, strBookingRefNo, intSaleID, strTypeProduct)

                    '-- 18/07/2018
                    'If intStep = 1 Then
                    '-----

                    If intSaleID > 0 Then
                        '-- ดำเนินการต่อคือ Sale นี้คือ PhoneNumber อะไร
                        strPhoneNumber = GetPhoneNumberBySale(intSaleID)

                        '--- สำหรับ เคสของ 3CX ไม่ต้องเช็ค และ ส่ง Callcenter (DID)
                        strReturn = "OK,SIP/" & strPhoneNumber & "," & intWaitingTimeSecond & ",Default,N," & strCustomerCall


                        '-- 18/07/2018 ตรวจสอบฝั่ง PlexTex เรื่องของ PhoneNumber -------------------------
                        'If CheckPlextel_PhoneNumber(strPhoneNumber) Or strPhoneNumber = "2412" Then '-- fix Or strPhoneNumber = "2412"  ( for test 3CX )
                        '    'OK,ExtensionID (SIP/XXXX),10,Default,N
                        '    strReturn = "OK,SIP/" & strPhoneNumber & "," & intWaitingTimeSecond & ",Default,N"
                        'Else
                        '    '--ถ้าไม่มี Sale ให้ Check TypeProduct
                        '    blnProcessQueue = True
                        'End If
                        '--------------------------------------------------------------------


                    Else
                        ' strReturn = "OK,,,Default,D"
                    End If

                    '-- 18/07/2018
                    'Else
                    '    blnProcessQueue = True
                    'End If
                    '-----

                Else ' กรณีที่หา ใครไม่ได้เลย
                    '  strReturn = "OK,,,Default,D"
                End If
            Else
                ' strReturn = "OK,,,Default,D"
            End If
                '------------------------------------------------------------------

                '-- 18/07/2018 เมื่อใช้งาน 3CX ก็ไม่ต้องจัดการ Queue แล้ว -------------------------
                'If blnProcessQueue Then ' กรณีที่ Process Queue ต่อ ซึ่งสิ่งที่ได้จากส่วนนี้คือ strTypeProduct
                '    strQueueName = GetQueueName(strTypeProduct)
                '    If CheckPlextel_QueueName(strQueueName, strMusicName) Then
                '        'strReturn = "OK,QUEUE/" & strQueueName & "," & intWaitingTimeSecond & ",Default,N"
                '        strReturn = "OK,QUEUE/" & strQueueName & ",648000," & strMusicName & ",N" ' กรณีที่โยนสายเข้า Queue ซึ่งจะต้องกำหนด ให้ Queue นั้นๆ ใช้เวลานานๆ ตาม Queue ==> 648000 คือ 3 ชั่วโมง
                '    Else
                '        strReturn = "OK,,,Default,D"
                '    End If
                'End If
                '--------------------------------------------------------------------------------

                '----- Fix Code --------------
                'If strStepnumber = "2" Then 'เนื่องจากข้างนอกไม่สามารถเรียก Queu จากตัวนี้ได้ ( for test 3CX )
                '    strReturn = "OK,Queue_GIT,648000,Default,N"
                'End If
                '------------------------



        Catch ex As Exception
            strReturn = ""
        End Try
        Return strReturn
    End Function
    Function GetQueueName(ByVal strTypeProduct As String) As String
        Dim strQueueName As String = ""
        Dim ClsQ As New CallCenter.TypeProduct_QueueName
        Try
            With ClsQ
                .Where.WhereClauseReset()
                .Where.TypeProduct.Value = strTypeProduct
                .Where.IsActive.Value = True
                .Query.Load()
                If .DefaultView.Count > 0 Then
                    strQueueName = .DefaultView(0)("QueueName").ToString()
                End If
            End With
        Catch ex As Exception
            strQueueName = ""
        Finally
            ClsQ = Nothing
        End Try
        Return strQueueName
    End Function
    Function GetSetWaitingTime() As Integer ' เป็นการ get ข้อมูลรอสาย
        Dim intWaitingTime As Integer = 10
        Try
            intWaitingTime = System.Configuration.ConfigurationSettings.AppSettings("WaitingTimeSecond")
        Catch ex As Exception
            intWaitingTime = 10
        End Try
        Return intWaitingTime
    End Function
    Function GetPhoneNumberBySale(ByVal intSaleID As Integer) As String
        Dim strPhoneNumber As String = ""
        Dim ClsSale As New CallCenter.Sale_Phonenumber
        Try
            With ClsSale
                .Where.WhereClauseReset()
                .Where.SaleID.Value = intSaleID
                .Where.IsActive.Value = True
                .Query.Load()
                If .DefaultView.Count > 0 Then
                    'แสดงว่ามีข้อมูล 
                    strPhoneNumber = .DefaultView(0)("PhoneNumber").ToString()
                End If
            End With
        Catch ex As Exception
            strPhoneNumber = ""
        Finally
            ClsSale = Nothing
        End Try
        Return strPhoneNumber
    End Function
    Function CheckExistCallerIDInDatabase(ByVal strCallerID As String, ByRef intPassengerID As Integer _
                                          , ByRef intCustomerCompamyID As Integer) As Boolean
        Dim bln As Boolean = False
        Dim ClsPassenger As New MushroomTravel.Passenger
        ClsPassenger.ConnectionString = System.Configuration.ConfigurationSettings.AppSettings("MushroomTravel")
        Dim Dtable As New DataTable
        Try
            intPassengerID = 0
            intCustomerCompamyID = 0
            With ClsPassenger
                '-- ตรวจสอบ Passenger & CustomerCompany
                .Where.WhereClauseReset()
                ._Proc_CheckCallerIDInBackOffice(strCallerID) ' เป็นการตรวจสอบข้อมูลทั้ง Passenger และ Customer Company
                If .DefaultView.Count > 0 Then
                    Dtable = .DefaultView.Table
                    For i As Integer = 0 To Dtable.Rows.Count - 1
                        Select Case Dtable.Rows(i)("TypeCaller").ToString()
                            Case "Passenger"
                                If Not IsDBNull(Dtable.Rows(i)("ID")) Then intPassengerID = CInt(Dtable.Rows(i)("ID").ToString())
                            Case "CustomerCompany"
                                If Not IsDBNull(Dtable.Rows(i)("ID")) Then intCustomerCompamyID = CInt(Dtable.Rows(i)("ID").ToString())
                        End Select
                    Next
                    bln = True
                End If
            End With
        Catch ex As Exception
            bln = False
        Finally
            ClsPassenger = Nothing
        End Try
        Return bln
    End Function
    Sub GetLastBookingByContactAndCompany(ByVal intPassengerID As Integer, ByVal intCustomerCompamyID As Integer _
                                          , ByRef strBookingRefNo As String, ByRef intSaleID As Integer, ByRef strTypeProduct As String)
        Dim ClsP As New MushroomTravel.Passenger
        ClsP.ConnectionString = System.Configuration.ConfigurationSettings.AppSettings("MushroomTravel")
        Dim Dtable As New DataTable
        Try
            'intBookingID, intSaleID, strTypeProduct
            With ClsP
                .Where.WhereClauseReset()
                ._Proc_GetLastBookingInBackOffice(intPassengerID, intCustomerCompamyID)
                If .DefaultView.Count > 0 Then
                    Dtable = .DefaultView.ToTable
                    strBookingRefNo = Dtable.Rows(0)("BookingCode").ToString()
                    intSaleID = CInt(Dtable.Rows(0)("SaleID").ToString())
                    strTypeProduct = Dtable.Rows(0)("TypeProduct").ToString()
                End If
            End With
        Catch ex As Exception
            intSaleID = 0
        Finally
            ClsP = Nothing
        End Try
    End Sub
    Sub ReturnToPlexTel(ByVal strReturn As String)
        Response.ContentType = "text/plain"
        Response.Write(strReturn)
        Response.End()
    End Sub
#Region "Function ที่เกี่ยวข้องกับ Plextel"
    Function getUserPasswordInSystem(ByVal strURLOLD As String) As String
        Dim strURLNew As String = strURLOLD
        Dim strUserName As String = ""
        Dim strPassword As String = ""

        Try
            '&username=PlexMItest&plexpass=PlexMItest
            strUserName = System.Configuration.ConfigurationSettings.AppSettings("UserName")
            strPassword = System.Configuration.ConfigurationSettings.AppSettings("Password")
            strURLNew = strURLNew & "&username=" & strUserName & "&plexpass=" & strPassword
        Catch ex As Exception
            strURLNew = strURLOLD
        End Try
        Return strURLNew
    End Function
    Function getDataFromPlexTel(ByVal strURLGet As String) As DataTable
        Dim DTable As New DataTable

        Try
            Dim objSURL As New StringBuilder
            Dim objURL As Uri
            Dim strURL As String

            strURL = getUserPasswordInSystem(strURLGet)
            objSURL.Append(strURL)
            objURL = New Uri(objSURL.ToString())

            Dim request As HttpWebRequest = HttpWebRequest.Create(objURL)
            Dim response As HttpWebResponse = request.GetResponse
            Dim reader As New StreamReader(response.GetResponseStream())

            If Not IsNothing(reader) Then
                Dim strResponse = reader.ReadToEnd
                DTable = JsonConvert.DeserializeObject(Of DataTable)(strResponse)
                'DTable = DirectCast(JsonConvert.DeserializeObject(reader.ReadToEnd, (GetType(DataTable))), DataTable)
                'If DTable.Rows.Count > 0 Then
                '    GridView1.DataSource = DTable
                '    GridView1.DataBind()
                'End If
            End If
            reader.Close()
            response.Close()
        Catch ex As Exception
            DTable = New DataTable
        End Try
        Return DTable
    End Function
    Function CheckPlextel_PhoneNumber(ByVal strPhoneNumber As String) As Boolean
        Dim bln As Boolean
        Dim Dt As New DataTable
        Try
            'function showuserall
            'URLPlextel_ShowUserAll
            Dim URLPlextel_ShowUserAll As String = System.Configuration.ConfigurationSettings.AppSettings("URLPlextel_ShowUserAll")
            Dt = getDataFromPlexTel(URLPlextel_ShowUserAll)
            If Dt.Rows.Count > 0 Then
                Dt.DefaultView.RowFilter = ""
                Dt.DefaultView.RowFilter = " phonenumber='" & strPhoneNumber & "' and status='OK' " ' มีอยู่ในระบบจริงๆและสถานะ On 
                If Dt.DefaultView.Count > 0 Then
                    ' แสดงว่าเจอบุคคลนั้นๆ

                    bln = True
                End If
                'bln = True
            End If
        Catch ex As Exception
            bln = False
        End Try
        Return bln
    End Function
    Function CheckPlextel_QueueName(ByVal strQueueName As String, ByRef strMusicName As String) As Boolean
        Dim bln As Boolean
        Dim Dt As New DataTable
        Try
            Dim URLPlextel_Showqueue As String = System.Configuration.ConfigurationSettings.AppSettings("URLPlextel_Showqueue")
            Dt = getDataFromPlexTel(URLPlextel_Showqueue)
            If Dt.Rows.Count > 0 Then
                Dt.DefaultView.RowFilter = ""
                Dt.DefaultView.RowFilter = " queueName='" & strQueueName & "' " ' มีอยู่ในระบบจริงๆและสถานะ On 
                If Dt.DefaultView.Count > 0 Then
                    strMusicName = Dt.DefaultView(0)("musiconhold")
                    bln = True
                End If
                'bln = True
            End If
        Catch ex As Exception
            bln = False
        End Try
        Return bln
    End Function
#End Region
End Class
