﻿Imports System.Data

Partial Class SystemAdmin_ProductDetail
    Inherits System.Web.UI.Page



    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load

        If Not Page.IsPostBack Then
            'ViewState("SortExpression") = "HistoryDateTime"
            'ViewState("SortDirection") = "ASC"

            ' txtPNRCode.Text = getCurrentDate()
            ' LoadHistoryLog(txtPNRCode.Text)
        End If
    End Sub
    Function getCurrentDate() As String
        Dim strDate As String = ""
        strDate = Date.Now.ToString("yyyy-MM-dd")
        Return strDate
    End Function

    Protected Sub btSearch_Click(sender As Object, e As EventArgs) Handles btSearch.Click
        ActionSearch()
    End Sub

    Sub ActionSearch()
        Dim strProductCode As String = RTrim(LTrim(txtProductCode.Text))
        If Len(strProductCode) > 5 Then
            If strProductCode <> "" Then LoadHistoryLog(strProductCode)
            If strProductCode <> "" Then LoadHistoryLog_PeriodDetail(strProductCode) 'GDActivityLog
            If strProductCode <> "" Then LoadHistoryLog_PeriodLog(strProductCode, "") 'GDBookingStatusLog
            If strProductCode <> "" Then LoadHistoryLog_PeriodStatusLog(strProductCode, "") 'GDBookingStatusLog
        End If
    End Sub

    Sub LoadHistoryLog_PeriodStatusLog(ByVal strPNRCode As String, ByVal strPeriodID As String) 'GDBookingStatusLog
        Try
            'GDPeriodStatuslog.DataSource = Nothing
            'GDPeriodStatuslog.DataBind()

            Dim DtBookingDetail As New DataTable
            DtBookingDetail = getBookingDetail_PeriodStatusLog(strPNRCode)

            If DtBookingDetail.DefaultView.Count > 0 Then
                If strPeriodID <> "" Then DtBookingDetail.DefaultView.RowFilter = " Product_detailID=" & strPeriodID
                GDPeriodStatuslog.DataSource = DtBookingDetail
                GDPeriodStatuslog.DataBind()
                lblResult_PeriodStatusLog.Text = " " & DtBookingDetail.DefaultView.Count & " items."
            Else
                GDPeriodStatuslog.DataSource = Nothing
                GDPeriodStatuslog.DataBind()
                lblResult_PeriodStatusLog.Text = " 0 items."
            End If
        Catch ex As Exception
            writeErrorLog("LoadHistoryLog_PeriodStatusLog", ex.Message.ToString())
        End Try
    End Sub

    Sub LoadHistoryLog_ProductScrape(ByVal strProductNameSupplier As String)
        Try
          
            Dim DtProductScrape As New DataTable
            DtProductScrape = getProductScrape(strProductNameSupplier)

            If DtProductScrape.DefaultView.Count > 0 Then

                GVProductScrape.DataSource = DtProductScrape
                GVProductScrape.DataBind()
                Label8.Text = "Product Scrape"

           
            End If
        Catch ex As Exception
            writeErrorLog("LoadHistoryLog_PeriodStatusLog", ex.Message.ToString())
        End Try
    End Sub

    Sub LoadHistoryLog_PeriodLog(ByVal strPNRCode As String, ByVal strPeriodID As String) 'GDBookingStatusLog
        Try

            'GDBookingPeriodLog.DataSource = Nothing
            'GDBookingPeriodLog.DataBind()

            Dim DtBookingDetail As New DataTable
            DtBookingDetail = getBookingDetail_PeriodLog(strPNRCode)

            If DtBookingDetail.DefaultView.Count > 0 Then
                If strPeriodID <> "" Then DtBookingDetail.DefaultView.RowFilter = " Product_detailID=" & strPeriodID
                GDBookingPeriodLog.DataSource = DtBookingDetail
                GDBookingPeriodLog.DataBind()
                lblResult_PeriodLog.Text = " " & DtBookingDetail.DefaultView.Count & " items."
            Else
                GDBookingPeriodLog.DataSource = Nothing
                GDBookingPeriodLog.DataBind()
                lblResult_PeriodLog.Text = " 0 items."
            End If
        Catch ex As Exception
            writeErrorLog("LoadHistoryLog_StatusLog", ex.Message.ToString())
        End Try
    End Sub

    Sub LoadHistoryLog_PeriodDetail(ByVal strPNRCode As String) 'GDActivityLog
        Try
            Dim DtBookingDetail As New DataTable
            DtBookingDetail = getBookingDetail_PeriodDetail(strPNRCode)

            If DtBookingDetail.DefaultView.Count > 0 Then
                GDPeriodDetail.DataSource = DtBookingDetail
                GDPeriodDetail.DataBind()
                lblResult_PeriodDetail.Text = " " & DtBookingDetail.DefaultView.Count & " items."
            Else
                GDPeriodDetail.DataSource = Nothing
                GDPeriodDetail.DataBind()
                lblResult_PeriodDetail.Text = " 0 items."
            End If


        Catch ex As Exception
            writeErrorLog("LoadHistoryLog_PeriodDetail", ex.Message.ToString())
        End Try
    End Sub

    Sub LoadHistoryLog(ByVal strProductCode As String) ' format yyyy-MM-dd

        Try
            Dim DtProductDetail As New DataTable
            DtProductDetail = getProductDetail(strProductCode)
            'lblHeaderDate.Text = ConvertDateString(strDate)


            If DtProductDetail.DefaultView.Count > 0 Then
                'DtBookingDetail.DefaultView.Sort = ViewState("SortExpression") & " " & ViewState("SortDirection")
                GvHistoryLog.DataSource = DtProductDetail
                GvHistoryLog.DataBind()
                lblResult.Text = " " & DtProductDetail.DefaultView.Count & " items."

            Else
                GvHistoryLog.DataSource = Nothing
                GvHistoryLog.DataBind()
                lblResult.Text = " 0 items."
            End If

            'GVCountry
            Dim DtCoutry As New DataTable
            DtCoutry = getCountry(strProductCode)

            If DtCoutry.DefaultView.Count > 0 Then
                GVCountry.DataSource = DtCoutry
                GVCountry.DataBind()
            Else
                GVCountry.DataSource = Nothing
                GVCountry.DataBind()
            End If


            If Not IsDBNull(DtProductDetail.Rows(0).Item("ProductNameSupplier")) Then
                LoadHistoryLog_ProductScrape(DtProductDetail.Rows(0).Item("ProductNameSupplier"))
            End If

        Catch ex As Exception
            writeErrorLog("LoadHistoryLog", ex.Message.ToString())
        End Try
    End Sub

    Sub writeErrorLog(ByVal strFunctionName As String, ByVal strError As String)
        lblError.Visible = True
        lblError.Text = "[" & strFunctionName & "] Err=" & strError
    End Sub

    Function ConvertDateString(ByVal strDate As String) As String
        'strDate => yyyy-mm-dd 
        'output => dd/mm/yyyy
        Dim strDateReturn As String = ""
        Dim ArrDate() As String
        Try
            ArrDate = Split(strDate, "-")
            strDateReturn = ArrDate(2) & "/" & ArrDate(1) & "/" & ArrDate(0)
        Catch ex As Exception
            strDateReturn = strDate
        End Try
        Return strDateReturn
    End Function

    Protected Sub GvHistoryLog_Sorting(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewSortEventArgs) Handles GvHistoryLog.Sorting
        'Try
        '    If ViewState("SortExpression") = e.SortExpression Then ' กรณีที่เป็นฟิลด์เดิม
        '        If ViewState("SortDirection") = "ASC" Then
        '            ViewState("SortDirection") = "DESC"
        '        Else
        '            ViewState("SortDirection") = "ASC"
        '        End If
        '    Else
        '        ViewState("SortExpression") = e.SortExpression
        '        ViewState("SortDirection") = "ASC"
        '    End If

        '    Dim strDateSearch As String = txtProductCode.Text
        '    LoadHistoryLog(strDateSearch)
        'Catch ex As Exception
        '    writeErrorLog("GvHistoryLog_Sorting", ex.Message.ToString())
        'End Try
    End Sub

#Region "get Database MushroomTravel"
    Function getSaleMushroom() As DataTable
        Dim Dt As New DataTable
        Dim ClsMUser As New MushroomTravel.M_User
        ClsMUser.ConnectionString = System.Configuration.ConfigurationSettings.AppSettings("MushroomTravel")

        Try
            With ClsMUser
                .Where.WhereClauseReset()
                .LoadAll()
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMUser = Nothing
        End Try
        Return Dt
    End Function

#End Region

#Region "get Booking Detail"
    Function getProductDetail(ByVal strProductCode As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsProduct As New Product
        Try
            With ClsProduct
                .Where.WhereClauseReset()
                ._HistoryLog_ProductDetail(strProductCode)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsProduct = Nothing
        End Try
        Return Dt
    End Function

    Function getProductCodeNewWH(ByVal strProductCode As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsProduct As New Product
        Try
            With ClsProduct
                .Where.WhereClauseReset()
                ._HistoryLog_GetProductCodeNewOriginal_WH(strProductCode)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsProduct = Nothing
        End Try
        Return Dt
    End Function



    Function getBookingDetail_PeriodDetail(ByVal strProductCode As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New Product
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_ProductDetail_Period(strProductCode)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function


    Function getCountry(ByVal strProductCode As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New Product
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_ProductDetail_Country(strProductCode)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function
    Function getBookingDetail_PeriodLog(ByVal strPNRCode As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New Product
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_ProductDetail_PeriodDetailLog(strPNRCode)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function
    Function getBookingDetail_PeriodStatusLog(ByVal strPNRCode As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New Product
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_ProductDetail_PeriodStatusLog(strPNRCode)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function

    Function getProductScrape(ByVal strProductnameSupplier As String) As DataTable
        Dim Dt As New DataTable
        Dim Cls As New Product
        Try
            With Cls
                .Where.WhereClauseReset()
                ._Proc_LoadHistoryLog_ProductScrape(strProductnameSupplier)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            Cls = Nothing
        End Try
        Return Dt
    End Function


#End Region

    Protected Sub GvHistoryLog_RowDataBound(sender As Object, e As GridViewRowEventArgs) Handles GvHistoryLog.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            e.Row.Cells(0).Text = e.Row.DataItemIndex + 1
        End If
    End Sub

    Protected Sub GDActivityLog_RowDataBound(sender As Object, e As GridViewRowEventArgs) Handles GDPeriodDetail.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            e.Row.Cells(0).Text = e.Row.DataItemIndex + 1
        End If
    End Sub

    Protected Sub GDBookingStatusLog_RowDataBound(sender As Object, e As GridViewRowEventArgs) Handles GDBookingPeriodLog.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            e.Row.Cells(0).Text = e.Row.DataItemIndex + 1
        End If
    End Sub

    Protected Sub GDPeriodStatuslog_RowDataBound(sender As Object, e As GridViewRowEventArgs) Handles GDPeriodStatuslog.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            e.Row.Cells(0).Text = e.Row.DataItemIndex + 1
        End If
    End Sub

    Protected Sub BtSearchPeriod_Click(sender As Object, e As EventArgs) Handles BtSearchPeriod.Click
        Dim strPeriodID As String = RTrim(LTrim(txtPeriodID.Text))
        Dim strProductCode As String = RTrim(LTrim(txtProductCode.Text))
        If Len(strPeriodID) > 5 Then
            If strProductCode <> "" Then LoadHistoryLog_PeriodLog(strProductCode, strPeriodID) 'GDBookingStatusLog
            If strProductCode <> "" Then LoadHistoryLog_PeriodStatusLog(strProductCode, strPeriodID) 'GDBookingStatusLog
        End If
    End Sub

    Protected Sub btSearchProductOriginalWH_Click(sender As Object, e As EventArgs) Handles btSearchProductOriginalWH.Click

        Dim strProductCodeNew_Sub As String = txtProductCodeNew.Text
        Dim strProductCodeNew_WH As String = ""
        Try
            If strProductCodeNew_Sub <> "" Then

                Dim DtProductDetail As New DataTable
                DtProductDetail = getProductCodeNewWH(strProductCodeNew_Sub)
                If DtProductDetail.DefaultView.Count > 0 Then
                    strProductCodeNew_WH = DtProductDetail.DefaultView(0)("ProductCodeNew_WH").ToString()
                    If strProductCodeNew_WH <> "" Then
                        txtProductCode.Text = strProductCodeNew_WH
                        ActionSearch()
                    End If
                Else
                    txtProductCode.Text = ""

                    GVCountry.DataSource = Nothing
                    GVCountry.DataBind()

                    GvHistoryLog.DataSource = Nothing
                    GvHistoryLog.DataBind()
                    lblResult.Text = " 0 items."

                    GDPeriodDetail.DataSource = Nothing
                    GDPeriodDetail.DataBind()
                    lblResult_PeriodDetail.Text = " 0 items."

                    GDBookingPeriodLog.DataSource = Nothing
                    GDBookingPeriodLog.DataBind()
                    lblResult_PeriodLog.Text = " 0 items."

                    GDPeriodStatuslog.DataSource = Nothing
                    GDPeriodStatuslog.DataBind()
                    lblResult_PeriodStatusLog.Text = " 0 items."

                End If
            End If
        Catch ex As Exception
            writeErrorLog("btSearchProductOriginalWH_Click", ex.Message.ToString())
        End Try
    End Sub

End Class
