﻿
Imports System.Data
Partial Class SystemAdmin_ClearDetail
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load

        If Session("TypeUserLogin") <> "systemadmin" Then
            Session("TypeUserLogin") = ""
            Session("CallCenterSystemAdmin") = Nothing
            Me.Page.Response.Redirect("~/Login.aspx")
        End If
        fnSwtichShowDelControl(False)
        LoadAgentData()


    End Sub

    Sub LoadAgentData()
        '--- Get Data ----
        Dim strAgentID As String = RTrim(LTrim(txtAgentID.Text))
        If Len(strAgentID) > 2 Then
            If strAgentID <> "" Then LoadHistoryLog(strAgentID)
        End If
    End Sub

    Sub fnSwtichShowDelControl(ByVal bln As Boolean)
        btDeleteBooking.Visible = bln
        btDeleteProduct.Visible = bln
        btDeletePassenger.Visible = bln
        btDeleteCustomerCompany.Visible = bln
        btDeleteCountSupplier.Visible = bln
    End Sub
    Sub LoadHistoryLog(ByVal strAgentID As String) ' format yyyy-MM-dd

        Try
            Dim DtProductDetail As New DataTable
            DtProductDetail = getAgentDetail(strAgentID)

            If DtProductDetail.DefaultView.Count > 0 Then
                'DtBookingDetail.DefaultView.Sort = ViewState("SortExpression") & " " & ViewState("SortDirection")
                GvHistoryLog.DataSource = DtProductDetail
                GvHistoryLog.DataBind()
                lblResult.Text = " " & DtProductDetail.DefaultView.Count & " items."
                If DtProductDetail.DefaultView.Count > 0 Then fnSwtichShowDelControl(True)
            Else
                GvHistoryLog.DataSource = Nothing
                GvHistoryLog.DataBind()
                lblResult.Text = " 0 items."
            End If
        Catch ex As Exception
            writeErrorLog("LoadHistoryLog", ex.Message.ToString())
        End Try
    End Sub

    Function getAgentDetail(ByVal strAgentID As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_AgentDetail(strAgentID)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function

    Sub writeErrorLog(ByVal strFunctionName As String, ByVal strError As String)
        lblError.Visible = True
        lblError.Text = "[" & strFunctionName & "] Err=" & strError
    End Sub

    Protected Sub btDeleteBooking_Click(sender As Object, e As EventArgs) Handles btDeleteBooking.Click
        Dim strAgentID As String = RTrim(LTrim(txtAgentID.Text))
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_DelBookingByAgentID(strAgentID)
            End With
            LoadAgentData()
        Catch ex As Exception

        Finally
            ClsMainBooking = Nothing
        End Try
    End Sub

    Protected Sub btDeleteProduct_Click(sender As Object, e As EventArgs) Handles btDeleteProduct.Click
        Dim strAgentID As String = RTrim(LTrim(txtAgentID.Text))
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_DelProductByAgentID(strAgentID)
            End With
            LoadAgentData()
        Catch ex As Exception

        Finally
            ClsMainBooking = Nothing
        End Try

    End Sub

    Protected Sub btDeletePassenger_Click(sender As Object, e As EventArgs) Handles btDeletePassenger.Click
        Dim strAgentID As String = RTrim(LTrim(txtAgentID.Text))
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_DelPassengerByAgentID(strAgentID)
            End With
            LoadAgentData()
        Catch ex As Exception

        Finally
            ClsMainBooking = Nothing
        End Try
    End Sub

    Protected Sub btDeleteCustomerCompany_Click(sender As Object, e As EventArgs) Handles btDeleteCustomerCompany.Click
        Dim strAgentID As String = RTrim(LTrim(txtAgentID.Text))
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_DelCustomerCompanyByAgentID(strAgentID)
            End With
            LoadAgentData()
        Catch ex As Exception

        Finally
            ClsMainBooking = Nothing
        End Try
    End Sub

    Protected Sub btDeleteCountSupplier_Click(sender As Object, e As EventArgs) Handles btDeleteCountSupplier.Click
        Dim strAgentID As String = RTrim(LTrim(txtAgentID.Text))
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_DelSupplierByAgentID(strAgentID)
            End With
            LoadAgentData()
        Catch ex As Exception

        Finally
            ClsMainBooking = Nothing
        End Try
    End Sub
    Protected Sub btDelProductCodeNew_Click(sender As Object, e As EventArgs) Handles btDelProductCodeNew.Click

        Dim strProductCodeNewDel As String = RTrim(LTrim(txtMultiProduct.Text))
        Dim strAgentID As String = RTrim(LTrim(txtAgentID.Text))
        If strProductCodeNewDel <> "" And IsNumeric(strAgentID) Then

            Dim ClsMainBooking As New MainBooking
            Try
                With ClsMainBooking
                    .Where.WhereClauseReset()
                    ._HistoryLog_DelProductByAgentID_byProductCode(strAgentID, strProductCodeNewDel)
                End With
                LoadAgentData()
            Catch ex As Exception
                lblError.Visible = True
                lblError.Text = "[btDelProductCodeNew_Click] Err=" & ex.Message.ToString()
            Finally
                ClsMainBooking = Nothing
            End Try
        End If
    End Sub

End Class
