﻿Imports System.Data

Partial Class SystemAdmin_Booking
    Inherits System.Web.UI.Page


    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load

        If Not Page.IsPostBack Then
            'ViewState("SortExpression") = "HistoryDateTime"
            'ViewState("SortDirection") = "ASC"

            ' txtPNRCode.Text = getCurrentDate()
            ' LoadHistoryLog(txtPNRCode.Text)
        End If
    End Sub
    Function getCurrentDate() As String
        Dim strDate As String = ""
        strDate = Date.Now.ToString("yyyy-MM-dd")
        Return strDate
    End Function

    Protected Sub btSearch_Click(sender As Object, e As EventArgs) Handles btSearch.Click
        Dim strPNRCode As String = RTrim(LTrim(txtPNRCode.Text)) ' Trim(Replace(txtPNRCode.Text, " ", ""))
        If Len(strPNRCode) > 5 Then
            If strPNRCode <> "" Then LoadHistoryLog(strPNRCode)
            If strPNRCode <> "" Then LoadHistoryLog_ActivityLog(strPNRCode) 'GDActivityLog
            If strPNRCode <> "" Then LoadHistoryLog_StatusLog(strPNRCode) 'GDBookingStatusLog
            If strPNRCode <> "" Then LoadHistoryLog_BookingInPeriod(strPNRCode) 'GDBookingStatusLog
        End If



    End Sub



    Sub LoadHistoryLog_BookingInPeriod(ByVal strPNRCode As String) 'GDBookingStatusLog
        Try
            Dim DtBookingDetail As New DataTable
            DtBookingDetail = getBookingDetail_BookingInPeriod(strPNRCode)

            If DtBookingDetail.DefaultView.Count > 0 Then
                GDBookingInPeriod.DataSource = DtBookingDetail
                GDBookingInPeriod.DataBind()
                lblResult_BookingInPeriod.Text = " " & DtBookingDetail.DefaultView.Count & " items."
            Else
                GDBookingInPeriod.DataSource = Nothing
                GDBookingInPeriod.DataBind()
                lblResult_BookingInPeriod.Text = " 0 items."
            End If
        Catch ex As Exception
            writeErrorLog("LoadHistoryLog_BookingInPeriod", ex.Message.ToString())
        End Try
    End Sub
    Sub LoadHistoryLog_StatusLog(ByVal strPNRCode As String) 'GDBookingStatusLog
        Try
            Dim DtBookingDetail As New DataTable
            DtBookingDetail = getBookingDetail_StatusLog(strPNRCode)

            If DtBookingDetail.DefaultView.Count > 0 Then
                GDBookingStatusLog.DataSource = DtBookingDetail
                GDBookingStatusLog.DataBind()
                lblResult_StatusLog.Text = " " & DtBookingDetail.DefaultView.Count & " items."
            Else
                GDBookingStatusLog.DataSource = Nothing
                GDBookingStatusLog.DataBind()
                lblResult_StatusLog.Text = " 0 items."
            End If
        Catch ex As Exception
            writeErrorLog("LoadHistoryLog_StatusLog", ex.Message.ToString())
        End Try
    End Sub
    Sub LoadHistoryLog_ActivityLog(ByVal strPNRCode As String) 'GDActivityLog
        Try
            Dim DtBookingDetail As New DataTable
            DtBookingDetail = getBookingDetail_ActivityLog(strPNRCode)

            If DtBookingDetail.DefaultView.Count > 0 Then
                GDActivityLog.DataSource = DtBookingDetail
                GDActivityLog.DataBind()
                lblResult_ActivityLog.Text = " " & DtBookingDetail.DefaultView.Count & " items."
            Else
                GDActivityLog.DataSource = Nothing
                GDActivityLog.DataBind()
                lblResult_ActivityLog.Text = " 0 items."
            End If
        Catch ex As Exception
            writeErrorLog("LoadHistoryLog_ActivityLog", ex.Message.ToString())
        End Try
    End Sub
    Sub LoadHistoryLog(ByVal strPNRCode As String) ' format yyyy-MM-dd

        Try
            Dim DtProductDetail As New DataTable
            DtProductDetail = getProductDetail(strPNRCode)
            'lblHeaderDate.Text = ConvertDateString(strDate)


            If DtProductDetail.DefaultView.Count > 0 Then
                'DtBookingDetail.DefaultView.Sort = ViewState("SortExpression") & " " & ViewState("SortDirection")
                GvHistoryLog.DataSource = DtProductDetail
                GvHistoryLog.DataBind()
                lblResult.Text = " " & DtProductDetail.DefaultView.Count & " items."
            Else
                GvHistoryLog.DataSource = Nothing
                GvHistoryLog.DataBind()
                lblResult.Text = " 0 items."
            End If
        Catch ex As Exception
            writeErrorLog("LoadHistoryLog", ex.Message.ToString())
        End Try
    End Sub
    Sub writeErrorLog(ByVal strFunctionName As String, ByVal strError As String)
        lblError.Visible = True
        lblError.Text = "[" & strFunctionName & "] Err=" & strError
    End Sub

    Function ConvertDateString(ByVal strDate As String) As String
        'strDate => yyyy-mm-dd 
        'output => dd/mm/yyyy
        Dim strDateReturn As String = ""
        Dim ArrDate() As String
        Try
            ArrDate = Split(strDate, "-")
            strDateReturn = ArrDate(2) & "/" & ArrDate(1) & "/" & ArrDate(0)
        Catch ex As Exception
            strDateReturn = strDate
        End Try
        Return strDateReturn
    End Function

    Protected Sub GvHistoryLog_Sorting(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewSortEventArgs) Handles GvHistoryLog.Sorting
        '        Try
        '            If 
        '("SortExpression") = e.SortExpression Then ' กรณีที่เป็นฟิลด์เดิม
        '                If ViewState("SortDirection") = "ASC" Then
        '                    ViewState("SortDirection") = "DESC"
        '                Else
        '                    ViewState("SortDirection") = "ASC"
        '                End If
        '            Else
        '                ViewState("SortExpression") = e.SortExpression
        '                ViewState("SortDirection") = "ASC"
        '            End If

        '            Dim strDateSearch As String = txtPNRCode.Text
        '            LoadHistoryLog(strDateSearch)
        '        Catch ex As Exception
        '            writeErrorLog("GvHistoryLog_Sorting", ex.Message.ToString())
        '        End Try
    End Sub

#Region "get Database MushroomTravel"
    Function getSaleMushroom() As DataTable
        Dim Dt As New DataTable
        Dim ClsMUser As New MushroomTravel.M_User
        ClsMUser.ConnectionString = System.Configuration.ConfigurationSettings.AppSettings("MushroomTravel")

        Try
            With ClsMUser
                .Where.WhereClauseReset()
                .LoadAll()
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMUser = Nothing
        End Try
        Return Dt
    End Function

#End Region
#Region "get Booking Detail"
    Function getProductDetail(ByVal strPNRCode As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_BookingDetail(strPNRCode)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function


    Function getBookingDetail_ActivityLog(ByVal strPNRCode As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_BookingDetail_ActivityLog(strPNRCode)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function
    Function getBookingDetail_StatusLog(ByVal strPNRCode As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_BookingDetail_StatusLog(strPNRCode)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function

    Function getBookingDetail_BookingInPeriod(ByVal strPNRCode As String) As DataTable
        Dim Dt As New DataTable
        Dim ClsMainBooking As New MainBooking
        Try
            With ClsMainBooking
                .Where.WhereClauseReset()
                ._HistoryLog_BookingDetail_BookingInPeriod(strPNRCode)
                If .DefaultView.Count > 0 Then
                    Dt = .DefaultView.ToTable
                End If
            End With
        Catch ex As Exception
            Dt = Nothing
        Finally
            ClsMainBooking = Nothing
        End Try
        Return Dt
    End Function


#End Region

    Protected Sub GvHistoryLog_RowDataBound(sender As Object, e As GridViewRowEventArgs) Handles GvHistoryLog.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            e.Row.Cells(0).Text = e.Row.DataItemIndex + 1
        End If
    End Sub
    Protected Sub GDActivityLog_RowDataBound(sender As Object, e As GridViewRowEventArgs) Handles GDActivityLog.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            e.Row.Cells(0).Text = e.Row.DataItemIndex + 1
        End If
    End Sub
    Protected Sub GDBookingStatusLog_RowDataBound(sender As Object, e As GridViewRowEventArgs) Handles GDBookingStatusLog.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            e.Row.Cells(0).Text = e.Row.DataItemIndex + 1
        End If
    End Sub

    Protected Sub GDBookingInPeriod_RowDataBound(sender As Object, e As GridViewRowEventArgs) Handles GDBookingInPeriod.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            e.Row.Cells(0).Text = e.Row.DataItemIndex + 1
        End If
    End Sub
End Class
